'use strict'

exports.port = process.env.PORT || 3001

exports.logLevel = 'prod'

exports.scanCamera = {
  enable: true,
  useMdns: true,
  lanIp: '', // '192.168.70.'
  lanPort: null, // '80'
  customList: [] // ['192.168.70.85:80', '192.168.70.89:80']
}
exports.hostUrl = '127.0.0.1:3000'
exports.eventUrl = ''
exports.webRtcUrl = ''
exports.hlsUrl = ''
exports.apiUrl = 'ast-streaming-server:9997'
exports.useS3 = false
exports.rtspProtocol = 'tcp'
exports.enablePlaybackRecording = false
exports.enableRecordingSettings = false
exports.playbackUrl = '127.0.0.1:3002'
exports.enableAudio = true
exports.enableRunOnInit = true
exports.pullType = 'ffmpeg'
exports.enableFFmpegWallclock = false
exports.enableFFmpegRate = false
exports.enableFFmpegNoBuffer = true
exports.enableFFmpegDiscardcorrupt = false
exports.enableFFmpegGenpts = false
exports.enableFFmpegPullRetry = false
exports.enableFFmpegPublishRetry = false
exports.ffmpegThreadNum = 4
exports.enableFFmpegBwOpt = true
exports.enableCorrectTS = true
exports.readTimeout = '10s'
exports.writeTimeout = '10s'
exports.enableSEIParser = false
exports.enableNonAuthPlayer = false
exports.enableHttps = false
exports.commandLogLevel = 'high'
exports.streamProtocol = 'webrtc'
exports.enableOpusEncode = false
exports.OpusEncodeMode = 'quality'
exports.enableNormalCamera = true
exports.playerTimeLimit = 0

exports.parallelStreamingServer = {
  enable: false, // Enable parallelization feature. Once enabled, this server will act as the central server and will cease support for camera control and mediamtx.
  servers: [
    // {
    //   name: 'server1',
    //   url: '192.168.70.156:3000',
    //   username: 'XXXXX',
    //   password: 'XXXXX'
    // }
  ]
}

exports.mongodb = {
  uri: process.env.MONGO_URI || 'mongodb://aspeed_db:db5274@localhost:27017/factory?authSource=admin'
}

exports.fov = {
  normal: {
    fov: 75,
    fovMin: 45,
    fovMax: 90
  },
  multiview: {
    fov: 75,
    fovMin: 45,
    fovMax: 90
  },
  fisheye: {
    fov: 75,
    fovMin: 45,
    fovMax: 90
  }
}

exports.cameraDefaultVFov = 85
exports.enableDenoise = false
exports.preloadCameraNum = 0
exports.waitingTimeForNextCamera = 5

exports.companyName = 'ASPEED'
exports.projectName = 'Cupola360 Studio Factory'
exports.systemEmail = 'your@email.addy'
exports.cryptoKey = 'k3yb0ardc4t'
exports.secretkey = 'b1ae027d534'
exports.expiresIn = '15 days'
exports.loginAttempts = {
  forIp: 50,
  forIpAndUser: 7,
  logExpiration: '20m'
}
exports.requireAccountVerification = false
exports.smtp = {
  from: {
    name: process.env.SMTP_FROM_NAME || exports.projectName + ' Website',
    address: process.env.SMTP_FROM_ADDRESS || 'your@email.addy'
  },
  credentials: {
    user: process.env.SMTP_USERNAME || 'your@email.addy',
    password: process.env.SMTP_PASSWORD || 'bl4rg!',
    host: process.env.SMTP_HOST || 'smtp.gmail.com',
    ssl: true
  }
}

exports.notificationInterval = 3600000
exports.maxOfflineCount = 3

exports.aws = {
  accessKeyId: process.env.AWS_KEY_ID || '',
  secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY || '',
  s3: {
    region: process.env.AWS_S3_REGION || '',
    bucket: process.env.AWS_S3_BUCKET || '',
    // keyPrefix: process.env.AWS_KEY_PREFIX || 'dev',
    keyPrefix: process.env.AWS_KEY_PREFIX || '',
    enalbeCDN: true
  }
}

exports.demoPath = './demo-video'
exports.enableDemoRunOnInit = false
exports.autoReorganizationPaths = true
exports.enableLockView = false
exports.enableScreenCapture = false
exports.sideFloorplanMode = 3 // 0: disable, 1: minimum, 2: small, 3: normal
exports.sideFloorplanIconDarkMode = true
exports.floorplanMaxScale = 4 // 最大縮放比例，預設為 4
exports.floorplanDefaultScaleInPlayer = 1 // 預設縮放比例，預設為 1
exports.enableNavigationIconTip = true

exports.enableAuthWebSocket = false

exports.enableStreamingProcessCleaner = true

exports.ironYun = {
  enable: false,
  enableObjectCounter: false,
  enableTimestamp: false,
  serverUrl: '', // 127.0.0.1:3000
  username: '', // vaidio admin username
  password: '', // vaidio admin password
  model: 'CPS-100' // vaidio model name
}

exports.cspDirectives = {
  defaultSrc: ['*', 'blob:'],
  imgSrc: ['*', 'data:', 'blob:'],
  frameAncestors: ['*']
}
