'use strict'

exports.port = process.env.PORT || 3001

// 紀錄等級設定，等級可以是 'prod'、'debug'、'info'、'warn'、'error'、或 'trace'
// Logging level settings， the level can be 'prod', 'debug', 'info', 'warn', 'error', or 'trace'.
exports.logLevel = 'prod'

exports.scanCamera = {
  // 是否開啟掃描功能，若不開啟則無法使用相機操作 Lib
  // Whether to enable scanning function. If not enabled, camera operation Lib cannot be used.
  enable: false,

  // 是否使用 mDNS 掃描，目前僅支援 Windows 版本。
  // Whether to use mDNS for scanning. Currently, it only supports Windows version.
  useMdns: false,

  // 手動指定掃描整個網路網段，若非特殊狀況不建議開啟
  // Manually specify scanning the entire network segment. It is not recommended to enable it under normal circumstances.
  lanIp: '', // '192.168.70.'
  lanPort: null, // '80'

  // 手動指定掃描固定相機 IP 和 Port
  // Manually specify scanning fixed camera IPs and Ports.
  customList: [] // '192.168.70.85:80', '192.168.70.89:80'
}

// 廠房圖片預設 endpoint 及設定 Syslog 回傳位置 (需含 port)。若有需要使用 Syslog 功能，則不可填寫為 127.0.0.1:3000。
// Default endpoint for factory pictures and setting Syslog return location (port included). If you need to use Syslog functionality, do not fill it in as 127.0.0.1:3000.
exports.hostUrl = '' // '192.168.70.48:3000'

// 非本機 event server Url。無獨立 event server 的話請留空。
// Non-local event server URL. If there is no independent event server, leave it empty.
exports.eventUrl = '' // '192.168.70.55:3000'

// WebRTC 連線位置(若填寫 IP 需含 port，或填寫 domain)，若使用 IP 瀏覽 Patrol 服務，並且 mediamtx 服務在同一台機器上，則可留空。
// WebRTC connection location (if IP is filled, it must include port, or fill in domain). If you are using IP to browse the Patrol service and the mediamtx service is on the same machine, you can leave it empty.
exports.webRtcUrl = '' // '192.168.70.132:8889' or 'patrol-mtx.cupola360.com'

// HLS 連線位置(若填寫 IP 需含 port，或填寫 domain)，若使用 IP 瀏覽 Patrol 服務，並且 mediamtx 服務在同一台機器上，則可留空。
// HLS connection location (if IP is filled, it must include port, or fill in domain). If you are using IP to browse the Patrol service and the mediamtx service is on the same machine, you can leave it empty.
exports.hlsUrl = '' // '192.168.70.132:8888'

// Mtx API 連線位置(需含 port)。必填。
// Mtx API connection location (port included). Required.
exports.apiUrl = '127.0.0.1:9997'

// 是否允許回放錄影
// Whether to allow playback of recordings.
exports.enablePlaybackRecording = false

// 是否允許開啟錄影設定
// Whether to allow recording settings.
exports.enableRecordingSettings = false

// playback server 的連線位置(需含 port)。若開啟錄影設定，則必填。
// Playback server connection location (port included). Required if recording settings are enabled.
exports.playbackUrl = '127.0.0.1:3002'

// 是否使用 AWS S3 來儲存圖片資料
// Whether to use S3 for storage.
exports.useS3 = false

exports.rtspProtocol = 'tcp' // udp (auto), udpOnly, tcp
exports.enableAudio = true
exports.enableRunOnInit = true
exports.pullType = 'ffmpeg'
exports.enableFFmpegWallclock = false
exports.enableFFmpegRate = false
exports.enableFFmpegNoBuffer = true
exports.enableFFmpegDiscardcorrupt = false
exports.enableFFmpegGenpts = false
exports.enableFFmpegPullRetry = false
exports.enableFFmpegPublishRetry = false
exports.ffmpegThreadNum = 4
exports.enableFFmpegBwOpt = true
exports.enableCorrectTS = true
exports.readTimeout = '10s'
exports.writeTimeout = '10s'
exports.enableSEIParser = false

// 是否開啟無需登入的播放器
// Enable player without requiring authentication
exports.enableNonAuthPlayer = false

// Enable HTTPS functionality through the backend, mainly used for activating gyroscope features in mobile players on internal networks
// 是否透過後端開啟 HTTPS 功能，主要用於內網啟用手機播放器陀螺儀功能
exports.enableHttps = false

exports.commandLogLevel = 'high'

// 播放器串流形式：hls、webrtc
// Player streaming protocol: 'hls' or 'webrtc'
exports.streamProtocol = 'webrtc'
exports.enableOpusEncode = false
exports.OpusEncodeMode = 'quality' // quality, performance

// 是否能新增一般相機
// Enable addition of normal camera
exports.enableNormalCamera = true

// 播放器觀看限制毫秒數，0 代表無限制
// Player viewing time limit in milliseconds, 0 means no limit
exports.playerTimeLimit = 0

exports.parallelStreamingServer = {
  // 是否開啟平行化功能，開啟後本伺服器將作為中央伺服器，並停止支援相機控制以及mediamtx
  // Whether to enable the parallelization feature, after enabling, this server will act as a central server, and stop supporting camera control and mediamtx.
  enable: false,
  servers: [
    // {
    //   name: 'server1',
    //   url: '192.168.70.156:3000',
    //   username: 'XXXXX',
    //   password: 'XXXXX'
    // }
  ]
}

exports.mongodb = {
  uri: process.env.MONGO_URI || 'mongodb://aspeed_db:db5274@localhost:27017/factory?authSource=admin'
}

// 各模式 fov 預設值
// Default FOV (Field of View) values for different modes.
exports.fov = {
  normal: {
    fov: 75,
    fovMin: 45,
    fovMax: 90
  },
  multiview: {
    fov: 75,
    fovMin: 45,
    fovMax: 90
  },
  fisheye: {
    fov: 75,
    fovMin: 45,
    fovMax: 90
  }
}

// 相機 vfov 預設值
// Default vfov (vertical field of view) value for the camera.
exports.cameraDefaultVFov = 85

exports.enableDenoise = false

// 巡檢時額外預先載入的相機串流數量，填寫 2 時代表除了載入當前觀看的相機串流外，會多載入下一台及下下台相機串流，以及上一台及上上台串流，總共 5 台
// Number of additional cameras to preload during patrol tour. If set to 2, it means that in addition to loading the current camera stream being viewed, it will also preload the next 2 camera streams and the previous 2 camera streams, making a total of 5 camera streams preloaded.
exports.preloadCameraNum = 0
exports.waitingTimeForNextCamera = 5 // 預設 5 秒，巡檢時切換相機的等待時間，若不需要可填寫 0

exports.companyName = 'ASPEED'
exports.projectName = 'Cupola360 Studio Factory'
exports.systemEmail = 'your@email.addy'
exports.cryptoKey = 'k3yb0ardc4t'
exports.secretkey = 'b1ae027d534'

// 登入 token 的過期時間
// Expiration time for login token
exports.expiresIn = '15 days'

// 登入嘗試次數限制
// 1. forIp: 每個 IP 最多嘗試次數
// 2. forIpAndUser: 每個 IP 和使用者組合最多嘗試次數
// 3. logExpiration: 登入嘗試記錄的過期時間
// Login attempt limits
// 1. forIp: Maximum number of attempts per IP
// 2. forIpAndUser: Maximum number of attempts per IP and user combination
// 3. logExpiration: Expiration time for login attempt records
exports.loginAttempts = {
  forIp: 50,
  forIpAndUser: 7,
  logExpiration: '20m'
}
exports.requireAccountVerification = false
exports.smtp = {
  from: {
    name: process.env.SMTP_FROM_NAME || exports.projectName + ' Website',
    address: process.env.SMTP_FROM_ADDRESS || 'your@email.addy'
  },
  credentials: {
    user: process.env.SMTP_USERNAME || 'your@email.addy',
    password: process.env.SMTP_PASSWORD || 'bl4rg!',
    host: process.env.SMTP_HOST || 'smtp.gmail.com',
    ssl: true
  }
}

// 相機通知功能時間間隔，單位為毫秒
// Camera notification function time interval, in milliseconds
exports.notificationInterval = 3600000

// 相機連續斷線通知次數閥值，連續達到此次數後才會發送離線通知。最低值為 1。
// Threshold for continuous disconnection notification count for cameras, notifications will be sent only after reaching this count. The minimum value is 1.
exports.maxOfflineCount = 3

exports.aws = {
  accessKeyId: process.env.AWS_KEY_ID || '',
  secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY || '',
  s3: {
    region: process.env.AWS_S3_REGION || '',
    bucket: process.env.AWS_S3_BUCKET || '',
    // keyPrefix: process.env.AWS_KEY_PREFIX || 'dev',
    keyPrefix: process.env.AWS_KEY_PREFIX || '',
    enalbeCDN: true
  }
}

exports.demoPath = './demo-video'
exports.enableDemoRunOnInit = false
exports.autoReorganizationPaths = true
exports.enableLockView = false

// 是否啟用相機拍照功能
// Enable camera capture function
exports.enableScreenCapture = false

// 播放器側邊小地圖模式 0: 禁用, 1: 最小, 2: 小, 3: 一般
// Player side map mode 0: Disabled, 1: Minimal, 2: Small, 3: Normal
exports.sideFloorplanMode = 3
exports.sideFloorplanIconDarkMode = true // 是否啟用側邊平面圖圖示深色模式
exports.floorplanMaxScale = 4 // 最大縮放比例，預設為 4
exports.floorplanDefaultScaleInPlayer = 1 // 預設縮放比例，預設為 1
exports.enableNavigationIconTip = true

// 是否啟用 WebSocket 連線驗證
// Enable WebSocket connection authentication
exports.enableAuthWebSocket = false

exports.enableStreamingProcessCleaner = true

exports.ironYun = {
  enable: false,
  enableObjectCounter: false,
  enableTimestamp: false,
  serverUrl: '', // 127.0.0.1:3000
  username: '', // vaidio admin username
  password: '', // vaidio admin password
  model: 'CPS-100' // vaidio model name
}

// 設定 content-security-policy 的參數
// Set parameters for content-security-policy
exports.cspDirectives = {
  defaultSrc: ['*', 'blob:'],
  imgSrc: ['*', 'data:', 'blob:'],
  frameAncestors: ['*']
}
