#!/bin/sh

# Get the absolute path of the script's directory
SCRIPT_DIR="$(cd "$(dirname "$0")" || exit 1; pwd)"
# Resolve the absolute path of the bin directory
# BIN_DIR="$(cd "$SCRIPT_DIR/../bin" || exit 1; pwd)"
ROOT_DIR="$(dirname "$SCRIPT_DIR")"

# Get the OS and CPU architecture
OS=$(uname -s)
ARCH=$(uname -m)

# Ensure the script is running on Linux
if [ "$OS" != "Linux" ]; then
    echo "Unsupported platform: OS=$OS. Only Linux is supported." >&2
    exit 1
fi

# Select the appropriate executable based on architecture
case "$ARCH" in
    x86_64)
        EXECUTABLE="$ROOT_DIR/cupola360-service-manager-linux-x64"
        ;;
    aarch64)
        EXECUTABLE="$ROOT_DIR/cupola360-service-manager-linux-arm64"
        ;;
    *)
        echo "Unsupported architecture: ARCH=$ARCH" >&2
        exit 1
        ;;
esac

# Ensure the executable exists
if [ ! -f "$EXECUTABLE" ]; then
    echo "Executable not found: $EXECUTABLE" >&2
    exit 1
fi

# Execute the appropriate binary
echo "Starting Cupola360 Service Manager : $EXECUTABLE"
exec "$EXECUTABLE" >> /var/log/cpl360_service_manager.log 2>&1