#!/bin/sh

# Ensure the script is run as root
if [ "$(id -u)" -ne 0 ]; then
    echo "This script must be run as root (use sudo to execute it)." >&2
    exit 1
fi

SERVICE_DIR="$(cd "$(dirname "$0")" || exit 1; pwd)"
SERVICES="cpl360_service_manager cpl360_totp_service"

# Ensure systemctl is available
if ! command -v systemctl >/dev/null 2>&1; then
    echo "Error: systemctl not found. This script requires systemd." >&2
    exit 1
fi

for SERVICE in $SERVICES; do
    echo "Starting service: $SERVICE.service..."
    if ! sudo systemctl start "$SERVICE.service"; then
        echo "Error: Failed to start service $SERVICE.service." >&2
        exit 1
    fi
done

# Display status of all services
for SERVICE in $SERVICES; do
    echo "Checking status of service: $SERVICE.service"
    if ! sudo systemctl status --no-pager "$SERVICE.service"; then
        echo "Error: Failed to get the status of service $SERVICE.service." >&2
        exit 1
    fi
done

echo "All specified services have been started successfully."