#!/bin/sh

# Ensure the script is run as root
if [ "$(id -u)" -ne 0 ]; then
    echo "This script must be run as root (use sudo to execute it)." >&2
    exit 1
fi

# Check if Docker is installed
if ! which docker > /dev/null 2>&1; then
    echo "Error: Docker is not installed. Please install Docker first before running this script." >&2
    exit 1
fi

# Check if the Docker group exists
if ! getent group docker > /dev/null; then
    echo "Creating Docker group..."
    groupadd docker
fi

# Get the current user
if [ -n "$SUDO_USER" ]; then
    USER_TO_MODIFY="$SUDO_USER"
else
    USER_TO_MODIFY="$(whoami)"
fi

# Add the current user to the Docker group
usermod -aG docker "$USER_TO_MODIFY"

# Prompt the user to execute newgrp to apply changes immediately
echo "Please log out and log back in, or run the following command to apply changes immediately:"
echo "newgrp docker"

# Test if the Docker group settings are applied
if su - "$USER_TO_MODIFY" -c "docker ps" > /dev/null 2>&1; then
    echo "Docker group setup successful. You can now run Docker commands without sudo."
else
    echo "Setup failed. Please check manually if the changes are applied and try again." >&2
fi